/* Código copiado de la librería PERSONAL de Jorge Alexis Viqueira Copyrigth ©2009
 * con autorización a iPlan para su uso en el producto WholeSale */

/* Propósito general */
var SECOND = 1000 ;/* milliseconds */
var MINUTE = 60 * SECOND;
var HOUR   = 60 * MINUTE;
var DAY    = 24 * HOUR;
var WEEK   =  7 * DAY;
var DAYS = ['Domingo', 'Lunes', 'Martes', 'Miércoles', 'Jueves', 'Viernes', 'Sábado'];
var DAYS_MIN = ['Do', 'Lu', 'Ma', 'Mi', 'Ju', 'Vi', 'Sá'];
var DAYS_SHORT = ['Dom', 'Lun', 'Mar', 'Mier', 'Ju', 'Vi', 'Sáb'];
var MONTHS = ['Enero', 'Febrero', 'Marzo', 'Abril', 'Mayo', 'Junio', 'Julio', 'Agosto', 'Septiembre', 'Octubre', 'Noviembre', 'Diciembre'];
var MONTHS_SHORT = ['Ene', 'Feb', 'Mar', 'Abr', 'May', 'Jun', 'Jul', 'Ago', 'Sep', 'Oct', 'Nov', 'Dic'];

var IMAGE_PATH = 'images/';


function replaceAcute(strText) {
    strText.replace("á", "a");
    strText.replace("é", "e");
    strText.replace("í", "i");
    strText.replace("ó", "o");
    strText.replace("ú", "u");
    return strText;
}

//Si la longitud del texto es menor de length, retorna el texto. Si es mayor, recorta hasta length caracteres y retorna un span con hint.
function stretchText(text, length) {
    var newText = text;
    if (text.length > length) {
        newText = hint(text.substr(0,length-2),text);
    }
    return newText;
}


/* Toma un texto y un hint y devuelve el HTML necesario para su visualización al mouseover.
 * @todo optimización: es MUY FEO anexar tanto texto al call. Se debe hacer un initializeHints() al estilo
 *                    screen bloquer y generar un array (o clase) que registre cada hint y lo almacene,
 *                    de modo de que el llamado sea del formato:
 *
 *                              javascript:showHint(23, this);
 */
function hint(text, hint) {
    return '<span onmouseover="javascript:$(this).simpletip({content:\''+hint+'\', baseClass:\'tooltip2\'});">'+text+'&hellip;</span>';
}

function dynamicHint(text, url, domPath) {
    var hint = "";
    send(url, "", function (data, extra) {
                    $(data).find("html body div div table").each(function() {hint = $(this).html()});
                   }, true, "", "html");
    return '<span onmouseover="javascript:$(this).simpletip({content:\''+hint+'\', baseClass:\'tooltip2\'});">'+text+'&hellip;</span>';
}

/* Hace un llamado AJAX como $().post pero blockea la pantalla.
 * IMPORTANTE: Sólo sirve para cosas que retornan un XML y NO ES ASINCRÓNICO.
 * 
 * El parámetro func tiene la siguiente signatura:
 *  function (data, textStatus) {...}
 */

var globalCounter = 1;
var debugDiv = "#debug";
var debugAjax = false;

function send(url, data, func, sync, extra, contentType) {
  var result;
  if (sync==undefined) sync = false;
  if (contentType==undefined) contentType = "Content-type: text/xml";
  $.ajax({
           async:sync,
           type: "POST",
           dataType: contentType,
           contentType: "application/x-www-form-urlencoded",
           url:url,
           data:data,
           beforeSend:beforeSend,
           success:function (data2) {
                if (debugAjax) {
                    var params = "";
                    for(param in data) {
                        params += '['+param+'='+data[param]+']'
                    }
                    var debug = "["+(globalCounter++)+"]["+data['action']+"] Params: "+params;
                    $(debugDiv).append('STA: '+new Date().toString()+debug+"<br>");
                }
                unBlockScreen();
                if (typeof extra == 'undefined' ){
                    result = func(data2);
                } else {
                    result = func(data2,extra);
                }

                if (debugAjax) {
                    $(debugDiv).append('END: '+new Date().toString()+debug+"<br>");
                }
           },
           timeout:4000,
           error:onSendError
         });
   return result;
}

function beforeSend() {
    blockScreen('Esperando respuesta del servidor...');
}
function onSendError(request, textStatus, errorThrown) {
    messageBlockScreen("Error en la conexi&oacute;n: "+textStatus + " "+errorThrown, true, true);
}


/*
 * Inicializa el sistema de prevención y blockeo de pantalla. Para ello configura el evento
 * "resize" de la ventana para que al cambiar de tamaño no se produzca un desfazaje en las
 * medidas del DIV.
 * Comprueba que #ScreenBlocker este visible.
 *
 * @todo habria que hacer que el initialize genere los Styles para que sea totalmente portable e independiente.
 **/
function initializeScreenBlocker(defaultMsg) {
    $('body').append('<div id="ScreenBlocker" class="screenBlocker">');
    if (defaultMsg)
        $('body').append('<div id="ScreenBlockerBox" class="screenBlockerBox"><img src="images/wait.gif">'+defaultMsg+'</div>');

    $('#ScreenBlockerBox').corner("round tr bl");
    $(window).resize(screenBlockerResize);
}

function screenBlockerResize() {
    if ($('#ScreenBlocker').css('display')=='block') {
        $('#ScreenBlocker').css({'width':$(document).width(),'height':$(document).height()});
        var box = $('#ScreenBlockerBox');
        var centroH = $(document).width()/2;
        var desvioH = box.width()/2;
        //alert("Document: "+centro+", Message:" + desvio);
        box.css('left', centroH-desvioH);
        var centroV = $(document).height()/2;
        var desvioV = box.height()/2;
        box.css('top', centroV-desvioV);
    }
}

function blockScreen(msg) {
    if ($('#ScreenBlocker').css('display') == 'none') {
        $('#ScreenBlocker').css({'display': 'block','width':$(document).width(),'height':$(document).height()});
        $('#ScreenBlockerBox').css({'display': 'block'}).empty().html(msg);
    }
}
function unBlockScreen(forced) {
    var screenBlocker = $('#ScreenBlocker');
    var screenBlockerBox = $('#ScreenBlockerBox');
    if (((screenBlocker.css('display') == 'block') && (!screenBlockerBox.hasClass('screenBlockerManual'))) || (forced)){
        screenBlocker.css('display','none');
        screenBlockerBox.css('display','none');
        screenBlockerBox.removeClass('screenBlockerManual')
    }
}

function messageBlockScreen(msg, append, showUnblock) {
    if (append==undefined) {
      append = false;
    }
    if (showUnblock==undefined) {
      showUnblock = false;
    }
    var screenBlocker = $('#ScreenBlocker');
    var screenBlockerBox = $('#ScreenBlockerBox');

    if (screenBlocker.css('display') == 'block') {
        screenBlockerBox.find('#screenBlocker_unblock').remove();
    } else {
        screenBlocker.css({'display': 'block','width':$(document).width(),'height':$(document).height()});
        screenBlockerBox.css({'display': 'block'});
    }
    if (append) {
        screenBlockerBox.append('<br>'+msg);
    } else {
        screenBlockerBox.html(msg);
    }
    if (showUnblock) {
        screenBlockerBox.append('<a id="screenBlocker_unblock" href="javascript:unBlockScreen(true);">Unblock</a>')
    }
    if (!screenBlockerBox.hasClass('screenBlockerManual'))
        screenBlockerBox.removeClass('screenBlockerManual');
    screenBlockerResize();
}

function isSet(variable) {
    return !(typeof variable=="undefined");
}

function dummy(data) {
    this.reference=data;
    return this;
}

/*
 * Recorre los elementos <OPTION> de un control <SELECT> y devuelve el que se
 * corresponde con el valor optionValue o null si no lo encuentra
 */
function getSelectedOption(selectId, optionValue) {
    var result = null;
    $("#"+selectId).find('option').each(function (index, element) {
            if (element.val() == optionValue) {
                result = element;
                return false;
            }
    });
    return result;
}